<?php

namespace App\Http\Controllers;

use App\Models\ContactUs;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Notifications\ContactFormSubmitted;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Notification;
use App\Mail\ContactFormEmail;
use App\Models\MyContactUs;
use ContactFormEmail as GlobalContactFormEmail;

class contactUsController extends Controller
{
    public function contact_form(Request $request)
    {
        $pagename = 'Contact form';
        return view(
            'contact_us.contact_form',
            [
                'pagename' => $pagename
            ]
        );
    }
    // public function store_contact_form_api(Request $request)
    // {
    //     $servicesArray = $request->input('services');
    //     $services = json_encode($servicesArray);
    //     $contact = ContactUs::create([
    //         'full_name' => $request->input('full_name'),
    //         'phone' => $request->input('phone'),
    //         'email' => $request->input('email'),
    //         'Company' => $request->input('Company'),
    //         'description' => $request->input('description'),
    //         'services' => $services,
    //         'created_at' => Carbon::now(),
    //         'updated_at' => Carbon::now(),
    //     ]);
    //     return response()->json([
    //         'message' => 'Contact Added Successfully',
    //         'contact' => $contact,
    //     ], 200);
    // }



    public function store_contact_form_api(Request $request)
    {
        // Process the form data and save it to the database
        $contact = new ContactUs();
        $contact->full_name = $request->input('full_name');
        $contact->phone_no = $request->input('phone_no');
        $contact->email = $request->input('email');
        $contact->message = $request->input('message');
        $contact->created_at = now();
        $contact->updated_at = now();
        $contact->save();

        // Create the email message
        $subject = 'Contact Form Submitted';

        // Construct the message with all form fields
        $message = "Name: " . $request->input('full_name') . "\n";
        $message .= "Email: " . $request->input('email') . "\n";
        $message .= "Phone: " . $request->input('phone_no') . "\n";
        $message .= "message: " . $request->input('message') . "\n";
       
        // Send the email notification
        // $recipient = 'hamirani.fareed80@gmail.com';
        $recipient = 'hamirani.fareed80@gmail.com';  // Replace with the recipient's email address

        Mail::raw($message, function ($message) use ($recipient, $subject) {
            $message->to($recipient)
                ->subject($subject);
        });

        return response()->json([
            'message' => 'Contact Form Submitted Successfully',
        ], 200);
    }








    // public function store_contact_form_api(Request $request)
    // {
    //     // Process the form data and save it to the database
    //     $contact = new ContactUs();
    //     $contact->full_name = $request->input('full_name');
    //     $contact->phone = $request->input('phone');
    //     $contact->email = $request->input('email');
    //     $contact->Company = $request->input('Company');
    //     $contact->description = $request->input('description');
    //     $contact->services = json_encode($request->input('services'));
    //     $contact->created_at = now();
    //     $contact->updated_at = now();
    //     $contact->save();

    //    // Send the email notification
    //    $recipient = 'shaikhkashan670@gmail.com';  // Replace with the recipient's email address
    //    $subject = 'Contact Form Submitted';
    //    $message = 'Contact Form details: ...';  // Customize your email message

    //    Mail::raw($message, function ($message) use ($recipient, $subject) {
    //        $message->to($recipient)
    //                ->subject($subject);
    //    });

    //     return response()->json([
    //         'message' => 'Contact Form Submitted Successfully',
    //     ], 200);
    // }



    public function store_contact_form(Request $request)
    {

        $services = json_encode($request->input('services'));
        ContactUs::create([
            'full_name' => $request->full_name,
            'phone'     => $request->phone,
            'email'     => $request->email,
            'Company'       => $request->Company,
            'description'   => $request->description,
            'services'   => $services,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        return redirect()->back()->with('contact-added', 'Contact Added Successfully');
    }
    public function form_list(Request $request)
    {
        $pagename = 'Form List';
        $all_data = ContactUs::all();
        return view('contact_us.form_list', [
            'pagename' => $pagename,
            'all_data' => $all_data,
        ]);
    }
    
}
