<?php

namespace App\Notifications;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class ContactFormSubmitted extends Notification
{
    public $contact;

    public function __construct($contact)
    {
        $this->contact = $contact;
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('New Contact Form Submission')
            ->line('A new contact form has been submitted:')
            ->line('Full Name: ' . $this->contact->full_name)
            ->line('Phone: ' . $this->contact->phone)
            ->line('Email: ' . $this->contact->email)
            ->line('Company: ' . $this->contact->Company)
            ->line('Description: ' . $this->contact->description)
            ->line('Services: ' . implode(', ', json_decode($this->contact->services)))
            ->action('View Contact', url('/contacts/' . $this->contact->id));
    }
}
